The full screen button is activated when the "show custom view" methods are overridden. However, there's some state issues that prevent this from working well

- On rotate, the video state is reset due to the orientation change
- On close, the scroll state is reset
```
open class AccompanistWebChromeClient : WebChromeClient() {
    private var customView: View? = null
    private var callback: CustomViewCallback? = null

    open lateinit var state: WebViewState
        internal set

    override fun onShowCustomView(view: View, callback: CustomViewCallback) {
        this.callback = callback
        if (customView != null) {
            this.callback?.onCustomViewHidden()
            return
        }


        targetView?.addView(view, FrameLayout.LayoutParams(-1, -1))
        customView = view
    }

    override fun onHideCustomView() {
        val view = this.customView ?: return
        targetView?.removeView(view)
        this.customView = null
        this.callback?.onCustomViewHidden()
    }
private val targetView: FrameLayout?
        get() = (state.webView?.context as? Activity)?.window?.decorView as FrameLayout?
}
```